////////////////////////////////////////////////////////////////////////////////
// Librairie pour le LCD du Nokia 3310
//
// Connecter le LCD au PORTB
//
////////////////////////////////////////////////////////////////////////////////
// Configuration de la connection du LCD
#define nok_sclk   RC4 
#define nok_sda    RC3
#define nok_dc     RC2 
#define nok_cs     RC6 
#define nok_res    RC7 
// Fin de Configuration
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// Envois le unsigned char pass en mode serie
////////////////////////////////////////////////////////////////////////////////
void LCD_write_dorc(unsigned char bytefornokia);
////////////////////////////////////////////////////////////////////////////////
// Prepare le LCD pour garder le unsigned char en la RAM
////////////////////////////////////////////////////////////////////////////////
void LCD_write_data(unsigned char byteforLCD_data);
////////////////////////////////////////////////////////////////////////////////
// Envois une commande a l'Ecran. Les commande s'activent avec D/C
////////////////////////////////////////////////////////////////////////////////
void LCD_write_command(unsigned char byteforLCD_command);
////////////////////////////////////////////////////////////////////////////////
// Ecrit un caractere sur le LCD
////////////////////////////////////////////////////////////////////////////////
void LCD_printchar(unsigned char character,unsigned int charmode);
////////////////////////////////////////////////////////////////////////////////
// Position sur l'ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_gotoxy(unsigned char xnokia, unsigned char ynokia);
////////////////////////////////////////////////////////////////////////////////
// Efface la RAM de l'ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_clean_ddram(void);
////////////////////////////////////////////////////////////////////////////////
// Initialise l'Ecran
////////////////////////////////////////////////////////////////////////////////
void Lcd_init(void);
////////////////////////////////////////////////////////////////////////////////
// Envois un string a l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_printstr(unsigned char x, unsigned char y,const char *str,unsigned int charMode);
////////////////////////////////////////////////////////////////////////////////
// Trace un Pixel sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_pixel(unsigned char pixelX,unsigned char pixelY,unsigned char pixelMode);
////////////////////////////////////////////////////////////////////////////////
// Trace une ligne sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_line(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char lineMode);
////////////////////////////////////////////////////////////////////////////////
// Trace un Rectangle sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_rect(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char rectMode);
////////////////////////////////////////////////////////////////////////////////
// Trace un Rectangle plein sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_rectfill(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char rectMode);
////////////////////////////////////////////////////////////////////////////////
// Trace un Cercle sur l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_circle(unsigned char centerX,unsigned char centerY,unsigned char radius,unsigned char circleMode);
////////////////////////////////////////////////////////////////////////////////
// Reaffiche l'Ecran
////////////////////////////////////////////////////////////////////////////////
void LCD_redraw(void);
////////////////////////////////////////////////////////////////////////////////
// Noici l'Ecran
////////////////////////////////////////////////////////////////////////////////
void ecran_noir(void);


