//Benzin fogyaszts mrs pic18f25j10
#include <pic18.h>
#include <hitech.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Nokia_LCD.h"
#include "delay.h"
#include "sajat.h"
#include <htc.h>

__CONFIG(1,XINSTDIS & WDTDIS & STVRDIS & DEBUGDIS);
__CONFIG(2,HSPLL & FCMDIS & IESODIS );
__CONFIG(3,CCP2RB3);

unsigned char s[20],s_imp_figy;
unsigned int szamlalo,injektor_nyitva,injektor_nyitvas,sebesseg_imp,sebesseg_imps,seged,injektor_ossz,sebesseg_imp_ossz; 
float akt_fogyasztas,akt_sebesseg,fogyasztas,oszzes_benzin,ossz_km,fseged;

  //192cm3/perc =>11.52 liter/ra=> 4*11.52=46.08liter/ra 
#define liter_sec 0.0128  //(liter/sec) tfolys nyitott szelepnl
#define injektor  46.08  //(liter/ra) tfolys nyitott szelepnl
#define seb_imp   0.00015625 //(km/impulzus) 
#define BETAP     RB0
#define ENTER     RB6
#define NYIL      RB7
#define INJEKTOR  RB2
#define SEBBESSEG RB1
#define TIMERN    38  

void BEALLITASOK(void)
{
  //RA0 analg a tbbi digitlis
  ADCON0=0B00000000;
  ADCON1=0B00001110;
  TRISA=0B11111111;
  TRISB=0B11111111;
  TRISC=0B00000000;
  PORTC=0;
  T0CON=0b01000111;
  T1CON=0b00000100; 
  INTCON=0b00100100;
  TMR0ON=0; 
}

void ALVAS(void)
{
 PEIE=1;
 RBIE=1;
 IPEN=1;  
 INT0IE=1; 
 RBIP=1;  
 LCD_clean_ddram();
 GIE=0;
 SLEEP();
 T0CON=0b01000111;
 T1CON=0b00000100; 
 INTCON=0b00100100;
 PEIE=0;
 RBIE=0;
 IPEN=0;  
 INT0IE=0; 
 RBIP=0; 
 GIE=1;
 TMR0ON=1;
 TMR0=255-TIMERN; 
}

void KIIRATAS(void)
{
     //aktulisan elhasznlt zemanyag 
     akt_fogyasztas=(float)injektor*((float)injektor_nyitvas/1000);
     akt_sebesseg=(float)sebesseg_imps*seb_imp;  //km 1sec alatt
     akt_sebesseg=(float)akt_sebesseg*3600; //km/ra
       if(akt_sebesseg<5) akt_sebesseg=90;
     //zemanyag fogyaszts szmtsa
     fogyasztas=1/akt_sebesseg; //ra/km
     fogyasztas=(float)fogyasztas*akt_fogyasztas*100; //fogyaszts 100km-re
     floattostr(fogyasztas,s,3);
     strcaat(s," 100Km/L");
     LCD_printstr(0,0,"              ",0);
     LCD_printstr(0,0,s,0);

     INTOSTR(s,injektor_nyitvas);
     strcaat(s," Ms");
     LCD_printstr(0,1,"              ",0);
     LCD_printstr(2,1,s,0);  

     floattostr(akt_sebesseg,s,1);
     strcaat(s," Km/ra");
     LCD_printstr(0,2,"              ",0);
     LCD_printstr(0,2,s,0);  

     INTOSTR(s,sebesseg_imps);
     strcaat(s," Imp./s");
     LCD_printstr(0,3,"              ",0);
     LCD_printstr(2,3,s,0);  
       //Az elhasznlt benzin
     fseged=(float)injektor_ossz; 
     injektor_ossz=0;
     fseged=(float)liter_sec*fseged;
     fseged=(float)(fseged/1000);     
     oszzes_benzin=(float)oszzes_benzin+fseged;
     floattostr(oszzes_benzin,s,3);
     strcaat(s," Liter");
     LCD_printstr(0,4,"              ",0);
     LCD_printstr(2,4,s,0);
       //Az sszes Km
     fseged=(float)sebesseg_imp_ossz;  
     sebesseg_imp_ossz=0;
     fseged=(float)seb_imp*fseged; 
     ossz_km=(float)ossz_km+fseged;
     floattostr(ossz_km,s,3);
     strcaat(s," Km");
     LCD_printstr(0,5,"              ",0);
     LCD_printstr(2,5,s,0);   
}

void interrupt isr(void)
{
  if(INJEKTOR==0)
    {
     injektor_nyitva++;
     injektor_ossz++;
    }
  if(SEBBESSEG==0&&s_imp_figy==0)
    {
     sebesseg_imp++;
     sebesseg_imp_ossz++;
     s_imp_figy=1;
    }
  if(SEBBESSEG==1&&s_imp_figy==1)
    {
     s_imp_figy=0;
    }
 szamlalo++;
 TMR0IF=0;
 TMR0=255-TIMERN; //ezred sec
}

void main(void)
{
 BEALLITASOK();
 Lcd_init();
 szamlalo=0;  
 injektor_nyitva=0;
 sebesseg_imp=0;
 sebesseg_imp_ossz=0;
 oszzes_benzin=(float)0.0;
 ossz_km=(float)0.0;
  if(SEBBESSEG==0) s_imp_figy=0;
              else s_imp_figy=1;
 TMR0=255-TIMERN; 
 GIE=1;
 TMR0ON=1; 
 do
  {  
    if(szamlalo>=1000)
       {
        szamlalo=0;
        injektor_nyitvas=injektor_nyitva;
        injektor_nyitva=0;
        sebesseg_imps=sebesseg_imp;
        sebesseg_imp=0; 
        KIIRATAS();
       }

     //Alvsi zemmd amg a slusszkulcs ki van vve
   // if(BETAP==0) ALVAS(); 
    
   }
 while(1); 
}







              
















