unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CoolTrayIcon, HotKeyManager, StdCtrls;

type
  TForm1 = class(TForm)
    HotKeyManager1: THotKeyManager;
    CoolTrayIcon1: TCoolTrayIcon;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HotKeyManager1HotKeyPressed(HotKey: Cardinal; Index: Word);

  private
    { Private declarations }
     procedure AddHotKey(HotKey: Cardinal);
    // procedure GetPotentialKeys;
  public
    { Public declarations }
    trayicon:TCoolTrayIcon;
  end;

var
  Form1: TForm1;
  ToShow: Boolean = False;


implementation

{$R *.dfm}
     uses U_CloseDlg;
const
  LOCALIZED_KEYNAMES = True;

type
  THotKeyEntry = class
    HotKey: Cardinal;
    constructor Create(iHotKey: Cardinal);
  end;

  TPotentialKey = class
    Key: Word;
    constructor Create(iKey: Word);
  end;

constructor THotKeyEntry.Create(iHotKey: Cardinal);
begin
  inherited Create;
  HotKey := iHotKey;
end;

constructor TPotentialKey.Create(iKey: Word);
begin
  inherited Create;
  Key := iKey;
end;

procedure TForm1.AddHotKey(HotKey: Cardinal);
begin
   if HotKeyManager1.AddHotKey(HotKey) <> 0 then
   Begin

   End
   else
    begin
     MessageDlg(HotKeyToText(HotKey, LOCALIZED_KEYNAMES) + ' Mar moglalt, nem lehet regisztralni.',
               mtWarning, [mbOk], 0);
     end;
   
End;


procedure TForm1.FormCreate(Sender: TObject);

var
   HotKeyVar: Cardinal;
begin
   // GYorsbillentyk megadsa  pl: Ctrl+Alt+F1
    HotkeyVar:=TextToHotkey('Ctrl+F1',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F2',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F3',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F4',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F5',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F6',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F7',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F8',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);

  Trayicon:=TCoolTrayIcon.create(self);
    with trayicon do
  begin
    persistenttrayicon:=false;    // nem latszik az ikon meg nyitva van a form
    Hint:= 'Klik a visszaallitashoz'; // buborek szoveg az ikon felett
    minimizetotray:=true; {sets action if user clicks sysmenu minimize icon}
    ShowFormOnTrayIconClick:=true;
  end;

  Label1.Caption:='Gyorsbillentyuk Ctrl+F1 - F2';
  Label2.Caption:='http://mselectronic.uw.hu';
  Label3.Caption:='Globlisan deklarlt gyosbillentyuk s a System Tray-ben val futtats';
  Form1.Caption:='Global HotKey and Minimalize to System Tray';
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    // nem kell

end;




procedure ShowDesktop(const YesNo : boolean) ;
var
  h : THandle;
  rc: boolean;
begin
  h := FindWindow('ProgMan', nil) ;
  h := GetWindow(h, GW_CHILD) ;
  if YesNo = True then
    rc := ShowWindow(h, SW_SHOW)
  else
    rc := ShowWindow(h, SW_HIDE) ;
  if rc then
    messagebeep(0);

end;

// gyorsbillenytukhoz tartozo utasitasokat itt lehet megadni
procedure TForm1.HotKeyManager1HotKeyPressed(HotKey: Cardinal; Index: Word);
var
   s:string;

   begin
    SetForegroundWindow(Application.Handle);
    // A kovetkez sor trlhet, hogy ne jelenjen meg minden utasitasnal a dialog ablak
    MessageDlg('Hotkey ' + HotKeyToText(HotKey, LOCALIZED_KEYNAMES) + ' pressed.', mtInformation, [mbOk], 0);

    s:=HotKeyToText(HotKey, LOCALIZED_KEYNAMES);
    if s='Ctrl+F1' then Begin{Uatsitas1} end;
    if s='Ctrl+F2' then Begin{Uatsitas2} end;
    if s='Ctrl+F3' then Begin{Uatsitas3} end;
    if s='Ctrl+F4' then Begin{Uatsitas4} end;
    if s='Ctrl+F5' then Begin{Uatsitas5} end;
    if s='Ctrl+F6' then Begin{Uatsitas6} end;
    if s='Ctrl+F7' then Begin{Uatsitas7} end;
    if s='Ctrl+F8' then Begin{Uatsitas8} end;
    // {Utasitas1-8} helyere beszurhatok a sajat utasitasok
end;


end.
