unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CoolTrayIcon, HotKeyManager, StdCtrls, jpeg, ExtCtrls;

type
  TForm1 = class(TForm)
    HotKeyManager1: THotKeyManager;
    CoolTrayIcon1: TCoolTrayIcon;
    Label1: TLabel;
    Label2: TLabel;
    Image1: TImage;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HotKeyManager1HotKeyPressed(HotKey: Cardinal; Index: Word);

  private
    { Private declarations }
     procedure AddHotKey(HotKey: Cardinal);
    // procedure GetPotentialKeys;
  public
    { Public declarations }
    trayicon:TCoolTrayIcon;
  end;

var
  Form1: TForm1;
  ToShow: Boolean = False;
  adat: smallint; //LPT-re kuldendo adat
  bit0,bit1,bit2,bit3,bit4,bit5,bit6,bit7:byte;

  procedure Out32(wAddr:word;bOut:byte); stdcall; external 'inpout32.dll'
  function Inp32(wAddr:word):integer; stdcall; external 'inpout32.dll'

implementation

{$R *.dfm}
     uses U_CloseDlg;
const
  LOCALIZED_KEYNAMES = True;

type
  THotKeyEntry = class
    HotKey: Cardinal;
    constructor Create(iHotKey: Cardinal);
  end;

  TPotentialKey = class
    Key: Word;
    constructor Create(iKey: Word);
  end;

constructor THotKeyEntry.Create(iHotKey: Cardinal);
begin
  inherited Create;
  HotKey := iHotKey;
end;

constructor TPotentialKey.Create(iKey: Word);
begin
  inherited Create;
  Key := iKey;
end;

procedure TForm1.AddHotKey(HotKey: Cardinal);
begin
   if HotKeyManager1.AddHotKey(HotKey) <> 0 then
   Begin

   End
   else
    begin
     MessageDlg(HotKeyToText(HotKey, LOCALIZED_KEYNAMES) + ' Mar foglalt, nem lehet regisztralni.',
               mtWarning, [mbOk], 0);
     end;

End;


procedure TForm1.FormCreate(Sender: TObject);

var
   HotKeyVar: Cardinal;
begin
   // GYorsbillentyk megadsa  pl: Ctrl+Alt+F1
    HotkeyVar:=TextToHotkey('Ctrl+F1',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F2',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F3',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F4',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F5',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F6',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F7',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);
    HotkeyVar:=TextToHotkey('Ctrl+F8',LOCALIZED_KEYNAMES);
    AddHotKey(HotKeyVar);

  Trayicon:=TCoolTrayIcon.create(self);
    with trayicon do
  begin
    persistenttrayicon:=false;    // nem latszik az ikon meg nyitva van a form
    Hint:= 'Klik a visszaallitashoz'; // buborek szoveg az ikon felett
    minimizetotray:=true; {sets action if user clicks sysmenu minimize icon}
    ShowFormOnTrayIconClick:=true;
  end;

  Label1.Caption:='Ctrl+F1,F2,F3,F4,F5,F6,F7,F8';
  Label2.Caption:='http://mselectronic.uw.hu';
  Form1.Caption:='LPT gyorsbillentyuvel';

  adat:=0;
  Out32 ($378,adat); //LPT port nullazasa

  checkbox1.Checked :=false;
  checkbox2.Checked :=false;
  checkbox3.Checked :=false;
  checkbox4.Checked :=false;
  checkbox5.Checked :=false;
  checkbox6.Checked :=false;
  checkbox7.Checked :=false;
  checkbox8.Checked :=false;

  checkbox1.Enabled:=false;
  checkbox2.Enabled:=false;
  checkbox3.Enabled:=false;
  checkbox4.Enabled:=false;
  checkbox5.Enabled:=false;
  checkbox6.Enabled:=false;
  checkbox7.Enabled:=false;
  checkbox8.Enabled:=false;

   bit0:=0;
   bit1:=0;
   bit2:=0;
   bit3:=0;
   bit4:=0;
   bit5:=0;
   bit6:=0;
   bit7:=0;


end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    // nem kell

end;




procedure ShowDesktop(const YesNo : boolean) ;
var
  h : THandle;
  rc: boolean;
begin
  h := FindWindow('ProgMan', nil) ;
  h := GetWindow(h, GW_CHILD) ;
  if YesNo = True then
    rc := ShowWindow(h, SW_SHOW)
  else
    rc := ShowWindow(h, SW_HIDE) ;
  if rc then
    messagebeep(0);

end;


// gyorsbillenytukhoz tartozo utasitasokat itt lehet megadni
procedure TForm1.HotKeyManager1HotKeyPressed(HotKey: Cardinal; Index: Word);
var
   s:string;

   begin
    SetForegroundWindow(Application.Handle);
    // A kovetkez sor trlhet, hogy ne jelenjen meg minden utasitasnal a dialog ablak
    //MessageDlg('Hotkey ' + HotKeyToText(HotKey, LOCALIZED_KEYNAMES) + ' pressed.', mtInformation, [mbOk], 0);

    s:=HotKeyToText(HotKey, LOCALIZED_KEYNAMES);

    if s='Ctrl+F1' then
       Begin{Uatsitas1}
         if Checkbox1.checked=true then Checkbox1.checked:=false else Checkbox1.checked:=true;
       end;
    if s='Ctrl+F2' then
       Begin
         if Checkbox2.checked=true then Checkbox2.checked:=false else Checkbox2.checked:=true;
       end;
    if s='Ctrl+F3' then
       Begin{Uatsitas3}
         if Checkbox3.checked=true then Checkbox3.checked:=false else Checkbox3.checked:=true;
       end;
    if s='Ctrl+F4' then
       Begin{Uatsitas4}
         if Checkbox4.checked=true then Checkbox4.checked:=false else Checkbox4.checked:=true;
       end;
    if s='Ctrl+F5' then
       Begin{Uatsitas5}
         if Checkbox5.checked=true then Checkbox5.checked:=false else Checkbox5.checked:=true;
       end;
    if s='Ctrl+F6' then
       Begin{Uatsitas6}
         if Checkbox6.checked=true then Checkbox6.checked:=false else Checkbox6.checked:=true;
       end;
    if s='Ctrl+F7' then
       Begin{Uatsitas7}
         if Checkbox7.checked=true then Checkbox7.checked:=false else Checkbox7.checked:=true;
       end;
    if s='Ctrl+F8' then
       Begin{Uatsitas8}
         if Checkbox8.checked=true then Checkbox8.checked:=false else Checkbox8.checked:=true;
       end;
       
    if checkbox1.checked=true then bit0:=1 else bit0:=0;
    if checkbox2.checked=true then bit1:=2 else bit1:=0;
    if checkbox3.checked=true then bit2:=4 else bit2:=0;
    if checkbox4.checked=true then bit3:=8 else bit3:=0;
    if checkbox5.checked=true then bit4:=16 else bit4:=0;
    if checkbox6.checked=true then bit5:=32 else bit5:=0;
    if checkbox7.checked=true then bit6:=64 else bit6:=0;
    if checkbox8.checked=true then bit7:=128 else bit7:=0;

    adat:=bit0+bit1+bit2+bit3+bit4+bit5+bit6+bit7; //kimeno kombinacio szamitas

    out32 ($378,adat);  //LPT-portra iras

end;


end.
