#include "project_config.h"
#include <math.h>
#include <delays.h>

void Timer0_Config ( float fTime )	//mSec-ban kell a szmll futsnak idejt megadni, 20MHz kristlyra van konfigurlva, MAX 3350ms-os idzts lehetsges
{
	/*
	+-----------------------------------------------------------+
	+ Ha a program ltal legtbbszr hasznlt idintervallumot  +
	+ ler if vezrlst elre teszed, hamarabb futhat le a kd +
	+-----------------------------------------------------------+
	*/

	unsigned float fT_TMR0;
	unsigned int iElotoltes = 0;
	unsigned char cFolyamatban = 1; //ha valamelyik kirtkels mr teljeslt, akkor nullzdik s a tbbi nem fut le

	if ( fTime <= 13 ) //1:1 eloszt <- 2*10^(-7)*65536 = 13ms lehet a maximlis rtk, felbonts = 2*10^(-7) = 0.0002ms = 0.2us
	{
		unsigned float fT_TMR0 = 0.0002;
		T0CON = 0b00001000;	//1:1 eloszt (3.bit!)
		cFolyamatban = 0;
	}
	if ( cFolyamatban && fTime > 13 && fTime <= 1670 ) //1:128 eloszt <- 2*10^(-7)*128*65536 = 1677ms lehet a maximlis rtk, felbonts = 2*10^(-7)*128 = 0.0256ms = 25.6us  
	{
		unsigned float fT_TMR0 = 0.0256;
		T0CON = 0b00000110;	//1:128 eloszt
		cFolyamatban = 0;
	}
	if ( cFolyamatban && fTime > 1670 && fTime <= 3350 ) //1:256 eloszt  <- 2*10^(-7)*256*65536 = 3355ms lehet a maximlis rtk, felbonts = 2*10^(-7)*256 = 0.0512ms = 51.2us
	{
		unsigned float fT_TMR0 = 0.0512;
		T0CON = 0b00000111;	//1:256 eloszt
		cFolyamatban = 0;
	}

	iElotoltes = fTime/fT_TMR0;	//kiszmolja hnyszor lptet a regiszter fTime id alatt
	iElotoltes = 65536 - iElotoltes;	//kiszmolja mekkora rtkkel kell feltlteni a TMR0-t
	TMR0L = iElotoltes;	//feltlti az als s fels bjtot
	TMR0H = iElotoltes >> 8;
}

float Homerseklet_szamito ( int iU_r1 )	// NTC termisztorral mrt hmrskletet szmolja ki
{
	// iU_r1 -> R1 ellenllson mrt feszltsggel arnyos szm (ADRES rtke)
	
	/*
	Felhasznlt sszefggsek: 
	Rntc = Aexp(B/T) -> exp(B/T) = Rntc/A ->
	U/R = Ur1/Rr1 -> R = U*Rr1/Ur1 -> Rntc = U*Rr1/Ur1 - Rr1
	*/

	#define _R1_	9980	// NTC termisztorral sorba kapcsolt ellenlls nagysga Ohm-ban
	#define CONST_A 0.01588	// NTC termisztorra jelemz rtk - katalgus adat
	#define CONST_B 4100	// NTC termisztorra jelemz rtk - katalgus adat
	#define _R1_X_UMAX _R1_*1024.0 //_R1_*1024 	//U*Rr1

	unsigned float fR_ntc = 0, fExp_B_T = 0, fLN_R_A = 0, fHomerseklet = 0;

	fR_ntc = (_R1_X_UMAX/iU_r1) - _R1_;	// Rntc = U*Rr1/Ur1 - Rr1
	fExp_B_T = fR_ntc / CONST_A;	// exp(B/T) = Rntc/A
	fLN_R_A = log( fExp_B_T );		// ln(Rntc/A) = B/T
	fHomerseklet = CONST_B/fLN_R_A;	// T = B/ln(Rntc/A)
	fHomerseklet -= 273.0;	// Ez Kelvin skln van, ezrt...
	return fHomerseklet;
}

int CCP_kulonbsegkepzo ( int Value, unsigned char* cFlag )	//kt esemny kztti TMR regiszter lptetsek szma
{
	static unsigned char cCounter = 0;
	static unsigned int Temp1 = 0, Temp2 = 0;
	unsigned int Differencia = 0;

	if ( cCounter == 0 )
	{
		Temp1 = Value;
		cCounter++;
		*cFlag = 0;
	}

	else
	{
		Temp2 = Value;
		CCP1CON = 0b00000000;
		Differencia = Temp2 - Temp1;
		cCounter = 0;
		*cFlag = 1;
	}

	return Differencia;
}

float Convert2Sec ( unsigned int TMR_x_value )	//TMR_x_value (TMR regiszter) rtkt tszmolja szekundumba
{
	#define F_TMR_X			32768.0
	#define TMR_X_PRESCALER	1.0
	#define T_TMR_X	(TMR_X_PRESCALER / F_TMR_X)

	float t = T_TMR_X * TMR_x_value;

	return t;
}

float Convert2Hz ( unsigned int TMR_x_value )	//TMR_x_value (peridusidbl) kiszmolja a frekvencit
{
	#define F_TMR_X			32768.0
	#define TMR_X_PRESCALER	1.0
	#define REC_T_TMR_X	(F_TMR_X / TMR_X_PRESCALER)

	float f = REC_T_TMR_X / TMR_x_value;

	return f;
}

char Prellmentesito ( char cAkkor )		//MG HIBSAN MKDIK!!! JAVTSD KI!!!
{
	//lekapcsolja a RB47 megszaktst, kivr, jravizsgl, kezel engedlyez
	//timer ha lejrt, aktivlja az RB47 megszaktst jelz bitet
	
	static char cLepes = 0;
	char cMost;

	if ( cLepes == 0 )
	{
		INTCON &= 0b11110110; //lekapcsolja a RB47 megszaktst, trli a jelzbitet
		cLepes++;
		TMR0H = 0x00;
		TMR0L = 0x00;
		T0CON = 0b10000000;	//T0 belltsa nhny ms ksleltetsre
		return 0;
	}

	else
	{
		cMost = (PORTB & 0b00110000);

		if ( cAkkor != ( cMost >> 4 ))	//rvid gombnyoms
		{
			cLepes = 0;
			return 1;	
		}	

		else	//hossz gombnyoms
		{
			return 2;	
		}	
	}
//	Delay1KTCYx(50);	//vr 10 ms - t
}