#include "project_config.h" //fordtsi paramterek
#include <timers.h>

void InitPorts (void)
{	
	OSCCON = 0b01110000;

	_asm
		clrf LATA, 0
		clrf PORTA, 0
		clrf TRISA, 0
		clrf ADCON1, 0

		clrf LATB, 0
		clrf PORTB, 0
		clrf TRISB, 0

		clrf LATC, 0
		clrf PORTC, 0
		clrf TRISC, 0

		clrf LATD, 0
		clrf PORTD, 0
		clrf TRISD, 0
	_endasm
	
	ADCON1 = 0b00001110;
}

void InitInterrupt (void)
{
	_asm 
		clrf INTCON, 0
		clrf INTCON2, 0
		clrf PIR1, 0
		clrf PIR2, 0
		clrf PIE1, 0
		clrf PIE2, 0
		clrf RCON, 0
	_endasm
}

#if T0_ENABLE
void InitT0 (void)
{
	_asm 
		clrf T0CON, 0
		clrf TMR0H, 0
		clrf TMR0L, 0
	_endasm	

//	TMR0H = 0x00;
//	TMR0L = 0x00;

	T0CON = TIMER_INT_OFF & T0_16BIT & T0_PS_1_32 & T0_SOURCE_INT;

	INTCONbits.TMR0IE = 1;
}
#endif

#if T1_ENABLE
void InitT1 (void)
{
	_asm 
		clrf T1CON, 0
		clrf TMR1H, 0
		clrf TMR1L, 0
	_endasm	

//	TMR1H = 0x00;
//	TMR1L = 0x00;

	T1CON = 0b00001011;

	PIE1bits.TMR1IE = 0;
}
#endif

#if T2_ENABLE
void InitT2 (void)
{
	_asm 
		clrf T2CON, 0
		clrf TMR2, 0
		clrf PR2, 0
	_endasm

//	TMR2 = 0x00;
	PR2 = 0b11111111;

	T2CON = 0b11111011 & T2_PS_1_1 & T2_POST_1_16; //T2 kikapcsolva, eloszt, utoszt
	
	PIE1bits.TMR2IE = 0;
}
#endif

#if T3_ENABLE
void InitT3 (void)
{
	_asm 
		clrf T3CON, 0
		clrf TMR3H, 0
		clrf TMR3L, 0
	_endasm

	TMR3H = 0x80;
	TMR3L = 0x00;

	T3CON = 0b00000011;
	
	PIE2bits.TMR3IE = 1;
}
#endif

#if AD1_ENABLE
void InitAD1 (void)
{
	_asm 
		clrf ADCON0, 0
		clrf ADCON1, 0
		clrf ADRESH, 0
		clrf ADRESL, 0
	_endasm	

	TRISA = 0b00000001;

	ADCON0 = 0b00000001;	//AD1 bekapcsolva, aktv csatorna AN0
	ADCON1 = 0b00001110;	//AN0 analg I/O
	ADCON2 = 0b10001100;	//0b10001100 Jobbra igaztott & 2TAD & Fosc/4

	PIE1bits.ADIE = 1;
}
#endif

#if CCP1_ENABLE
void InitCCP1 (void)
{
	_asm 
		clrf CCP1CON, 0
		clrf CCPR1H, 0
		clrf CCPR1L, 0
	_endasm

	TRISCbits.TRISC2 = 1;	//RC2 = CCP1 I/O

//	CCPR1H = 0x00;
//	CCPR1L = 0x00;

	CCP1CON = 0b00000100; //Capture mode: every falling edge

	PIE1bits.CCP1IE = 1;
}
#endif

#if CCP2_ENABLE
void InitCCP2 (void)
{
	_asm 
		clrf CCP2CON, 0
		clrf CCPR2H, 0
		clrf CCPR2L, 0
	_endasm

	TRISCbits.TRISC1 = 1;	//RC1 = CCP2 I/O

//	CCPR2H = 0x00;
//	CCPR2L = 0x00;

	CCP2CON = 0b00000100; //Capture mode: every falling edge

	PIE2bits.CCP2IE	= 1;
}
#endif

#if PWM1_ENABLE
void InitPWM1 (void)
{
	_asm 
		clrf CCP1CON, 0
		clrf CCPR1H, 0
		clrf CCPR1L, 0
	_endasm

	TRISCbits.TRISC2 = 0;	//RC2 = CCP1 I/O

	CCPR1H = 0x00;
	CCPR1L = 0x00;
	PR2 = 0b11111111;

	CCP1CON = 0b00111100;
}
#endif

#if PWM2_ENABLE
void InitPWM2 (void)
{
	_asm 
		clrf CCP2CON, 0
		clrf CCPR2H, 0
		clrf CCPR2L, 0
	_endasm

	TRISCbits.TRISC1 = 0;	//RC1 = CCP2 I/O

	CCPR2H = 0x00;
	CCPR2L = 0x00;
	PR2 = 0b11111111;

	CCP2CON = 0b00111100;
}
#endif

#if USART_ENABLE
void InitUSART (void)
{
	#define CLKFRQ 20000000
	#define SYNC_	0
	#define BRG16_	0
	#define BRGH_	0
	#define BAUDRATE	2400

	#if !SYNC_ && !BRG16_ && !BRGH_
		#define OSZTO	64
	#elif ( BRG16_ || BRGH_) && !SYNC_
		#define OSZTO	16
	#else
		#define OSZTO	4
	#endif		
	
	#define BAUD(X) ((CLKFRQ/OSZTO)/X)-1

	_asm
		clrf SPBRG, 0
		clrf TXSTA, 0
		clrf RCSTA, 0
		clrf TXREG, 0
		clrf RCREG, 0
	_endasm	

	TRISCbits.TRISC6 = 1;	//TX - kimen - kimenet - 0
	TRISCbits.TRISC7 = 1;	//RX - bejv - bemenet - 1

	SPBRG = BAUD( BAUDRATE );	//BAUDRATE kbps
	BAUDCONbits.BRG16 = BRG16_;

	//8bit, TX bekapcsol, asszinkron,
	TXSTAbits.SYNC = SYNC_;
	TXSTAbits.BRGH = BRGH_;
	TXSTAbits.TXEN = 1;

	RCSTA = 0b10010000;	//Soros port be, 8bit, X, folyamatos fogads, cmzs ki, frame-overrun error, 9th bit

	PIR1 &= 0b11001111;	//RC s TX flag trlse PIR1_5:4
	PIE1 |= 0b00110000;	//RC s TX megszakts engedlyezse PIE1_5:4
}
#endif
