#include "project_config.h"
#include <delays.h>

//Fordtsi paramterek
//---------------------------------------------------------------------------
#define	FOUR_BIT_ENABLE	0	//4bites md hasznlathoz rd t 1-re

//SPLC780C vezrl bitjei (~HD44780) - LLTSD BE A MEGFELEL PORTOKAT
//---------------------------------------------------------------------------
#define LCD_POWER LATAbits.LATA5	//RS
#define LCD_RS	LATAbits.LATA2	//RS
#define LCD_RW	LATAbits.LATA3	//RW
#define LCD_E	LATAbits.LATA4	//ENABLE
#define LCD_DB	LATD			//ADAT
	
//SPLC780C utastsai (~HD44780)
//---------------------------------------------------------------------------
#define CLEAR_DISPLAY	0b00000001
#define RETURN_HOME	0b00000010
#define FOUR_BIT   	0b00101111  /* 4-bit Interface               */
#define EIGHT_BIT  	0b00111111  /* 8-bit Interface               */
#define LINE_5X8   	0b00110011  /* 5x8 characters, single line   */
#define LINE_5X10  	0b00110111  /* 5x10 characters               */
#define LINES_5X8  	0b00111011  /* 5x8 characters, multiple line */

#define DISPLAY_ON  0b00001111  /* Display on      */
#define DISPLAY_OFF 0b00001011  /* Display off     */
#define CURSOR_ON   0b00001111  /* Cursor on       */
#define CURSOR_OFF  0b00001101  /* Cursor off      */
#define BLINK_ON    0b00001111  /* Cursor Blink    */
#define BLINK_OFF   0b00001110  /* Cursor No Blink */
#define UNDERLINE_ON    0b00001111
#define UNDERLINE_OFF   0b00001101

#define INCREMENT	0b00000111	/* Entry mode increment */
#define DECREMENT	0b00000101	/* Entry mode decrement */
#define SHIFT_ON	0b00000111	/* Display shift on		*/
#define SHIFT_OFF	0b00000110	/* Display shift off	*/

#define SHIFT_CURSOR_LEFT	0b00010000 /* Kurzor balra lptets */
#define SHIFT_CURSOR_RIGHT	0b00010100 /* Kurzor jobbra lptets */
#define SHIFT_DISPLAY_LEFT	0b00011000 /* Kijelz balra lptets */
#define SHIFT_DISPLAY_RIGHT	0b00011100 /* Kijelz jobbra lptets */

void Pulse_LCD_Enable (void)
{
	LCD_E = 1;
	Nop();Nop();Nop();Nop();Nop();
	LCD_E = 0;
}

void LCDCmd ( unsigned char c )
{
	LCD_RS = 0;
	LCD_RW = 0;

#if FOUR_BIT_ENABLE		//4bit-es md
	LCD_DB &= 0xf0;
	LCD_DB |= (c >> 4);
	Pulse_LCD_Enable();
	Delay1KTCYx(5); // Delay of 5ms

	LCD_DB &= 0xf0;
	LCD_DB |= (c & 0x0f);
	Pulse_LCD_Enable();
#else					//8bit-es md
	LCD_DB = c;
	Pulse_LCD_Enable();
#endif

	Delay1KTCYx(10); // Delay of 5ms
			// Cycles = (TimeDelay * Fosc) / 4
			// Cycles = (5ms * 20MHz) / 4
			// Cycles = 25,000
}

void LCDChar ( unsigned char c ) 
{
	LCD_RS = 1;
	LCD_RW = 0;

#if FOUR_BIT_ENABLE		//4bit-es md
	LCD_DB &= 0xf0;
	LCD_DB |= (c >> 4);
	Pulse_LCD_Enable();
	Delay1KTCYx(5); // Delay of 5ms

	LCD_DB &= 0xf0;
	LCD_DB |= (c & 0x0f);
	Pulse_LCD_Enable();
#else					//8bit-es md
	LCD_DB = c;
	Pulse_LCD_Enable();
#endif

	Delay1KTCYx(10); // Delay of 5ms
}

void LCDString ( unsigned char* cString ) 
{
	char n = 0;	

	while ( *(cString + n) != 0 )	//0 a string vgt jelzi, ha odart, akkor tudja hogy vge
	{
		LCDChar(*(cString + n));
		n++;
	}

	Delay1KTCYx(10); // Delay of 5ms
}

void LCDString_Addr ( unsigned char* cString, char cCim )
{
	char n = 0;	
	
	LCDCmd ( cCim | 0b10000000 );

	while ( *(cString + n ) != 0 )	//0 a string vgt jelzi, ha odart, akkor tudja hogy vge
	{
		LCDChar(*(cString + n));
		n++;
	}

	Delay1KTCYx(10); // Delay of 5ms
}

void InitLCD (void)
{	
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 0;
	
	LCD_POWER = 1;

	Delay1KTCYx(200); // Delay of 40ms

#if FOUR_BIT_ENABLE		//4bit-es md
	LCDCmd (FOUR_BIT & LINES_5X8);
	LCDCmd (FOUR_BIT & LINES_5X8);
	LCDCmd (FOUR_BIT & LINES_5X8);
#else					//8bit-es md
	LCDCmd (EIGHT_BIT & LINES_5X8);
	LCDCmd (EIGHT_BIT & LINES_5X8);
	LCDCmd (EIGHT_BIT & LINES_5X8);
#endif
	
	LCDCmd (INCREMENT & SHIFT_OFF);
	LCDCmd (DISPLAY_ON & BLINK_OFF & UNDERLINE_OFF);
	LCDCmd (CLEAR_DISPLAY);

/*
	LCDCmd ( 0b01000000 );
	LCDChar (0b00001110);
	LCDChar (0b00010001);
	LCDChar (0b00001110);
	LCDChar (0b00000100);
	LCDChar (0b00011111);
	LCDChar (0b00000100);
	LCDChar (0b00001010);
	LCDChar (0b00010001);

	LCDChar (0b00001110);
	LCDChar (0b00010001);
	LCDChar (0b00001110);
	LCDChar (0b00010101);
	LCDChar (0b00001110);
	LCDChar (0b00000100);
	LCDChar (0b00001010);
	LCDChar (0b00010001);

	LCDChar (0b00001110);
	LCDChar (0b00010001);
	LCDChar (0b00001110);
	LCDChar (0b00000100);
	LCDChar (0b00001110);
	LCDChar (0b00010101);
	LCDChar (0b00001010);
	LCDChar (0b00010001);

	LCDChar (0b00000010);
	LCDChar (0b00000101);
	LCDChar (0b00000010);
	LCDChar (0b00000000);
	LCDChar (0b00000000);
	LCDChar (0b00000000);
	LCDChar (0b00000000);
	LCDChar (0b00000000);
*/

	LCDCmd ( 0b10000000 );
	LCDCmd (CLEAR_DISPLAY);
}


void BCD_c ( unsigned char cErtek, unsigned char* Digit1_ptr, unsigned char* Digit2_ptr, unsigned char* Digit3_ptr )
{
	unsigned char cSzazas = 0, cTizes = 0, cEgyes = 0;
	
	while (cErtek >= 100)
	{
		cErtek-= 100;
		cSzazas++;
	}

	while (cErtek >= 10)
	{
		cErtek-= 10;
		cTizes++;
	}

	cEgyes = cErtek;

	if (Digit3_ptr != 0) *Digit3_ptr = cSzazas + 48;
	if (Digit2_ptr != 0) *Digit2_ptr = cTizes + 48;
	*Digit1_ptr = cEgyes + 48;
}

/*
void BCD_c ( unsigned char cErtek, unsigned char* cSzamjegyek )
{
	unsigned char cSzazas = 0, cTizes = 0, cEgyes = 0, n = 0;
	
	while (cErtek >= 100)
	{
		cErtek-= 100;
		cSzazas++;
	}

	while (cErtek >= 10)
	{
		cErtek-= 10;
		cTizes++;
	}

	cEgyes = cErtek;

	if (cSzazas != 0) *(cSzamjegyek + n++ ) = cSzazas + 48;
	if (cTizes != 0) *(cSzamjegyek + n++ ) = cTizes + 48;
	*(cSzamjegyek + n++ ) = cEgyes + 48;
	*(cSzamjegyek + n ) = 0;
}
*/

void BCD_i ( unsigned int iErtek, unsigned char* cSzamjegyek )
{
	unsigned char cTizezres = 0, cEzres = 0, cSzazas = 0, cTizes = 0, cEgyes = 0, n = 0;

	while (iErtek >= 10000)
	{
		iErtek-= 10000;
		cTizezres++;
	}

	while (iErtek >= 1000)
	{
		iErtek-= 1000;
		cEzres++;
	}
	
	while (iErtek >= 100)
	{
		iErtek-= 100;
		cSzazas++;
	}

	while (iErtek >= 10)
	{
		iErtek-= 10;
		cTizes++;
	}

	cEgyes = iErtek;

	if (cTizezres != 0) *(cSzamjegyek + n++ ) = cTizezres + 48;
	if (cEzres != 0) *(cSzamjegyek + n++ ) = cEzres + 48;
	if (cSzazas != 0) *(cSzamjegyek + n++ ) = cSzazas + 48;
	if (cTizes != 0) *(cSzamjegyek + n++ ) = cTizes + 48;
	*(cSzamjegyek + n++ ) = cEgyes + 48;
	*(cSzamjegyek + n ) = 0;
}

void BCD_f ( unsigned float fErtek, unsigned char* cSzamjegyek )
{
	unsigned int iErtek;
	unsigned char cEzres = 0, cSzazas = 0, cTizes = 0, cEgyes = 0, Pont_helye = 4, n = 0;

	if ( fErtek < 10)	//Egyjegy
	{
		iErtek = fErtek*1000;
		Pont_helye = 1;
	}
	else if  ( fErtek < 100)	//Ktjegy
	{
		iErtek = fErtek*100;
		Pont_helye = 2;
	}
	else if ( fErtek < 1000)	//Hromjegy
	{
		iErtek = fErtek*10;
		Pont_helye = 3;	
	}
	else	//Ngy-, vagy tbbjegy
	{
		iErtek = fErtek;
	}
		
	while (iErtek >= 1000)
	{
		iErtek-= 1000;
		cEzres++;
	}
	
	while (iErtek >= 100)
	{
		iErtek-= 100;
		cSzazas++;
	}

	while (iErtek >= 10)
	{
		iErtek-= 10;
		cTizes++;
	}

	cEgyes = iErtek;

	*( cSzamjegyek + Pont_helye )  = 0b00101110;

	if (n == Pont_helye) n++;
		*(cSzamjegyek + n++ )  = cEzres + 48;
	if (n == Pont_helye) n++;
		*(cSzamjegyek + n++ ) = cSzazas + 48;
	if (n == Pont_helye) n++;
		*(cSzamjegyek + n++ ) = cTizes + 48;
	if (n == Pont_helye) n++;
		*(cSzamjegyek + n++ ) = cEgyes + 48;
	*(cSzamjegyek + n ) = 0;
}

