#include <p18f4550.h>

#include "project_config.h"
#include "init.h"
#include "interrupt.h"
#include "lcd.h"
#include "usart.h"

#pragma config FOSC = HS, WDT = OFF, MCLRE = ON, LVP= OFF, CCP2MX = ON	//ON = RC1, OFF = RB3

//Ms forrs llomnyokban definilt vltozk
extern unsigned char cAD_FLAG;

//Globlis vltozk

//Multitask mkdshez szksges jelzbitek

#if USE_INTERRUPT
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh (void) //tirnyts a magas priorits megszaktskezelhz
{
	_asm
	goto InterruptHandlerHigh
	_endasm
}
#if LOW_PR_IE
#pragma code InterruptVectorLow = 0x18
void InterruptVectorLow (void) //tirnyts az alacsony priorits megszaktskezelhz
{
	_asm
	goto InterruptHandlerLow
	_endasm
}
#endif //LOW_PR_IE
#pragma code
#endif //USE_INTERRUPT

void main ()
{
	unsigned float Homerseklet;
	unsigned char cDigits[8];
	unsigned char n = 0;
	unsigned char cString1[] = "OK!";

	InitPorts ();

#if USE_INTERRUPT
	InitInterrupt ();
#endif
#if T0_ENABLE
	InitT0 ();
#endif
#if T1_ENABLE
	InitT1 ();
#endif
#if T2_ENABLE
	InitT2 ();
#endif
#if T3_ENABLE
	InitT3 ();
#endif
#if AD1_ENABLE
	InitAD1 ();
#endif
#if CCP1_ENABLE
	InitCCP1 ();
#endif
#if CCP2_ENABLE
	InitCCP2 ();
#endif
#if PWM1_ENABLE
	InitPWM1 ();
#endif
#if PWM2_ENABLE
	InitPWM2 ();
#endif
#if USART_ENABLE
	InitUSART ();
#endif
#if USE_INTERRUPT
	INTCON |= 0b11000000; //GIE s PEIE engedlyezse
#endif

	InitLCD ();

	LCDString ( cString1 );

	while (1)
		{
			;
		}
}

