#include "project_config.h" //fordtsi paramterek

//Ms forrs llomnyokban definilt vltozk
unsigned char  cAD_FLAG = 0, cTX_FLAG = 0, cRX_FLAG = 0;
unsigned char cString_USART_TX[] = "Ez a teszt!";

#if USE_INTERRUPT
#pragma interrupt InterruptHandlerHigh
void InterruptHandlerHigh (void) //magas priorits megszaktskezel
{
#if T0_IE
	if ( INTCONbits.TMR0IF )
	{
		//TMR0H = 0x00;
		//TMR0L = 0x00;

		T0CON = 0;	//T0 kikapcsols
		INTCON |= 0b00001001; //aktivlja az RB47 megszaktst s jelz bitet
		
		INTCONbits.TMR0IF = 0;		
	}
#endif //T0_IE

#if T1_IE
	if ( PIR1bits.TMR1IF )
	{	
//		TMR1H = 0x00;
//		TMR1L = 0x00;

		PIR1bits.TMR1IF = 0;
	}
#endif //T1_IE

#if T2_IE
	if ( PIR1bits.TMR2IF )
	{	
		//TMR2 = 0x00;
		//PR2 = 0x00;
		
		PIR1bits.TMR2IF = 0;
	}
#endif //T2_IE

#if T3_IE
	if ( PIR2bits.TMR3IF )
	{	
		TMR3H = 0x80;
		TMR3L = 0x00;

		PIR2bits.TMR3IF = 0;
	}
#endif //T3_IE

#if USART_IE
	if ( PIR1bits.RCIF )
	{
		LCDChar( USARTReadByte() );
		PIR1bits.RCIF = 0;
	}

	if ( PIR1bits.TXIF )
	{
		USARTWriteString ( cString_USART_TX );
		PIR1bits.TXIF = 0;
	}
#endif

#if AD1_IE
	if ( PIR1bits.ADIF )
	{	
		cAD_FLAG = 1;
		PIR1bits.ADIF = 0;	
	}
#endif //AD1_IE

#if CCP1_IE
	if ( PIR1bits.CCP1IF )
	{	
		
	
		PIR1bits.CCP1IF = 0;
	}
#endif //CCP1_IE

#if CCP2_IE
	if ( PIR2bits.CCP2IF )
	{	
		

		PIR2bits.CCP2IF = 0;
	}
#endif //CCP2_IE

#if RB47_IE
	if ( INTCONbits.RBIF )
	{
		/*
		+-------------------------------------------------------------------------------+
		+ Ez a minta maszkolst hasznl, gy lehetv teszi a multiplexelt gombkezelst +
		+-------------------------------------------------------------------------------+
		*/

		#define RB47_CHANGE_INT_MASK 0b00110000 //RB4:7 bitek maszkja
		char x = ( PORTB & RB47_CHANGE_INT_MASK );
		x >>= 4;
		
		switch ( x )
		{
			case 1:	//RB1 nyomva - 0-ra hz nyomskor
				if ( Prellmentesito( x ) )
				{

				}
				break;
			
			case 2:	//RB0 nyomva
				if ( Prellmentesito( x ) )
				{

				}
				break;

			case 3:	//RB0 s RB1 nyomva
				if ( Prellmentesito( x ) )
				{

				}
				break;
		}
		INTCONbits.RBIF = 0;
	}
#endif //RB47_IE

#if INT0_IE
	if ( INTCONbits.INT0IF )
	{

		INTCONbits.INT0IF = 0;
	}
#endif //INT0_IE

#if INT1_IE
	if ( INTCON3bits.INT1IF )
	{

		INTCON3bits.INT1IF = 0;
	}
#endif //INT1_IE

#if INT2_IE
	if ( INTCON3bits.INT2IF )
	{

		INTCON3bits.INT2IF = 0;
	}
#endif //INT2_IE


}
#endif //USE_INTERRUPT

#if LOW_PR_IE
#pragma interruptlow InterruptHandlerLow
void InterruptHandlerLow (void) //alacsony priorits megszaktskezel
{

}
#endif //LOW_PR_IE

